Array.prototype.includes = function (value) {
    return this.indexOf(value) !== -1
}
String.prototype.characterize = function (callback) {
    var characters = this.split('');
    var options = {};

    for (var i = 0; i < this.length; i++) {
        options = callback(characters[i]);
    }
}

var $textarea;
var $highlight;
var $keywords = ['False', 'None', 'True', 'and', 'as', 'assert', 'break', 'class', 'continue', 'def', 'del', 'elif', 'else', 'except', 'finally', 'for', 'from', 'global', 'if', 'import', 'in', 'is', 'lambda', 'nonlocal', 'not', 'or', 'pass', 'raise', 'return', 'try', 'while', 'with', 'yield'];
var $functions = ['abs', 'dict', 'help', 'min', 'setattr', 'all', 'dir', 'hex', 'next', 'slice', 'any', 'divmod', 'id', 'object', 'sorted', 'ascii', 'enumerate', 'input', 'oct', 'staticmethod', 'bin', 'eval', 'int', 'open', 'str', 'bool', 'exec', 'isinstance', 'ord', 'sum', 'bytearray', 'filter', 'issubclass', 'pow', 'super', 'bytes', 'float', 'iter', 'print', 'tuple', 'callable', 'format', 'len', 'property', 'type', 'chr', 'frozenset', 'list', 'range', 'vars', 'classmethod', 'getattr', 'locals', 'repr', 'zip', 'compile', 'globals', 'map', 'reversed', '_import_', 'complex', 'hasattr', 'max', 'round', 'delattr', 'hash', 'memoryview', 'set'];

function tokenize(inputString) {
    var tokens = [];
    var lexedValue = '';
    var currentToken = null;
    function newSpaceToken() {
        currentToken = { type: 'space', value: ' ' };
        lexedValue = '';
    }

    function parseLexedValueToToken() {
        if (lexedValue) {
            if ($keywords.includes(lexedValue)) {
                tokens.push({ type: 'keyword', value: lexedValue })
            } else if ($functions.includes(lexedValue)) {
                tokens.push({ type: 'function', value: lexedValue })
            } else if (lexedValue !== '') {
                if (isNaN(lexedValue)) {
                    tokens.push({ type: 'default', value: lexedValue })
                } else {
                    tokens.push({ type: 'number', value: lexedValue })
                }
            }
            lexedValue = '';
        }
    }

    function lex(char) {
        if (char !== ' ' && currentToken && currentToken.type === 'space') {
            tokens.push(currentToken);
            lexedValue = '';
            currentToken = null;
        }

        switch (char) {
            case ' ':
                if ($keywords.includes(lexedValue)) {
                    tokens.push({ type: 'keyword', value: lexedValue })
                    newSpaceToken();
                } else if ($functions.includes(lexedValue)) {
                    tokens.push({ type: 'function', value: lexedValue })
                    newSpaceToken();
                } else if (lexedValue !== '') {
                    if (isNaN(lexedValue)) {
                        tokens.push({ type: 'default', value: lexedValue })
                    } else {
                        tokens.push({ type: 'number', value: lexedValue })
                    }
                    newSpaceToken();
                } else if (currentToken) {
                    currentToken.value += ' '
                } else {
                    newSpaceToken();
                }
                break;

            case '\'':
                if (currentToken) {
                    if (currentToken.type === 'string') {
                        if (currentToken.value[0] === char) {
                            currentToken.value += char
                            tokens.push(currentToken)
                            currentToken = null;
                        } else {
                            currentToken.value += char
                        }
                    } else if (currentToken.type === 'comment') {
                        currentToken.value += char
                    }
                } else {
                    if (lexedValue) {
                        tokens.push({ type: 'default', value: lexedValue });
                        lexedValue = '';
                    }
                    currentToken = { type: 'string', value: char }
                }
                break;

            case '=':
            case '+':
            case '-':
            case '*':
            case '/':
            case '%':
            case '&':
            case '|':
            case '>':
            case '<':
            case '!':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    tokens.push({ type: 'operator', value: char })
                }
                break;

            case '#':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    currentToken = { type: 'comment', value: char }
                }
                break;

            case ':':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    tokens.push({ type: 'colon', value: char });
                }
                break;

            case '(':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    tokens.push({ type: 'left-parentheses', value: char });
                }
                break;

            case ')':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    tokens.push({ type: 'right-parentheses', value: char });
                }
                break;

            case '[':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    tokens.push({ type: 'left-bracket', value: char });
                }
                break;

            case ']':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    tokens.push({ type: 'right-bracket', value: char });
                }
                break;

            case ',':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    tokens.push({ type: 'comma', value: char });
                }
                break;

            case '\n':
                if (currentToken) {
                    switch (currentToken.type) {
                        case 'string':
                        case 'comment':
                            tokens.push(currentToken)
                            currentToken = null;
                            break;
                        default:
                    }
                } else {
                    parseLexedValueToToken();
                    lexedValue = '';
                }
                tokens.push({ type: 'newline', value: '\n' });
                break;

            case ';':
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    parseLexedValueToToken();
                    tokens.push({ type: 'semicolon', value: char });
                }
                break;

            default:
                if (currentToken) {
                    currentToken.value += char;
                } else {
                    lexedValue += char
                }

                break;
        }
    }

    inputString.characterize(lex);
    parseLexedValueToToken();
    if (currentToken) tokens.push(currentToken);

    var isFunctionArgumentScope = false;
    var tokenCount = tokens.length;
    for (var i = 0; i < tokenCount; i++) {
        var token = tokens[i];
        if (token.type === 'keyword' && (token.value === 'def' || token.value === 'class')) {
            var peekToken = tokens[i + 2]
            if (peekToken && peekToken.type === 'default') peekToken.type = 'function-name';
        } else if (token.type === 'default' && isFunctionArgumentScope) {
            token.type = 'argument';
        } else if (token.type === 'left-parentheses') {
            var peekToken = tokens[i - 1]
            if (peekToken && peekToken.type === 'function-name') { isFunctionArgumentScope = true };
            if (peekToken && peekToken.type === 'default') { peekToken.type = 'function-name'; }
        } else if (token.type === 'right-parentheses') {
            isFunctionArgumentScope = false;
        };
    };

    return tokens;
}

$("#selectallacc").click(function () {

    if (!$('.check_acc:checkbox').is('checked')) {
        $('.check_acc:checkbox').attr('checked', 'checked');
    } else {
        $('.check_acc:checkbox').removeAttr('checked');
    }

    if (this.checked) {
        $(".check_acc").each(function () {
            this.checked = true;
        });
    } else {
        $(".check_acc").each(function () {
            this.checked = false;
        });
    }

    checkedaccount();
});

function add_thread() {
    var select = '';
    for (let index = 1; index < 201; index++) {
        select += "<option value='" + index + "' >" + index + "</option>";
    }
    document.getElementById("thread").innerHTML = select;
    select = '';

    for (let index = 1; index < 11; index++) {
        select += "<option value='" + index + "' >" + index + " Tab</option>";
    }
    document.getElementById("inline").innerHTML = select;
    select = '';

    for (let index = 1; index < 21; index++) {
        select += "<option value='" + index + "' >" + index + " CPU</option>";
    }
    document.getElementById("cpu").innerHTML = select;
}

function clear_uncheck(checkclass) {
    var els = document.querySelectorAll(checkclass + ':checked');
    els.forEach((v) => {
        if (v.checked) {
            v.click();
        }
    });
}
function check_scheduler() {
    var els = document.querySelectorAll(".choice_scheduler");
    els.forEach((v) => {
        if (v.value == 'on') {
            return true;

        }
    });
    return false
}
function loadpage() {
    var today = new Date()
    var yyyy = today.getFullYear();
    var mm = today.getMonth() + 1;
    var dd = today.getDate();
    if (dd < 10) { dd = '0' + dd; }
    if (mm < 10) { mm = '0' + mm; }
    time = [today.getHours(), today.getMinutes(), today.getSeconds()].join(':');
    var day = ("0" + today.getDate()).slice(-2);
    var month = ("0" + (today.getMonth() + 1)).slice(-2);
    var formattedToday = today.getFullYear() + "-" + (month) + "-" + (day);
    document.getElementById("body").focus();
    random = Math.random().toString(36).slice(-6);
    document.getElementById("sche_name_script").value = 'scr' + random;
    document.getElementById("sche_date").value = formattedToday;
    document.getElementById("sche_time").value = time;
}
function tablechoice(evt, cityName) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    document.getElementById(cityName).style.display = "block";
    evt.currentTarget.className += " active";
}
function tablechoice2(evt, cityName, table_content = "tabcontent2", table_link = "tablinks2") {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName(table_content);
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName(table_link);
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    document.getElementById(cityName).style.display = "block";
    evt.currentTarget.className += " active";
}
function sort_object(unordered) {
    var ordered = Object.keys(unordered).sort().reduce((obj, key) => {
        obj[key] = unordered[key];
        return obj;
    }, {});
    return ordered;
}
function random_change(idrd) {
    var min = document.getElementById('minnumber_random_' + idrd).value;
    var max = document.getElementById('maxnumber_random_' + idrd).value;
    document.getElementById('value_' + idrd).value = min + "," + max;
}

function dropDown(index, options, setvalue) {
    var select = '<select id="' + index + '"  data-var="' + index + '">';
    var option = Object();
    for (const [key, value] of Object.entries(options)) {
        selelected = '';
        if (setvalue == key) {
            selelected = 'selected';
        }
        select += '<option value="' + key + '" ' + selelected + '>' + value + '</option>';
    }
    select += '</select>';
    return select;
}

function load_data_js(number) {
    $.each(number, function (arrayIndex, elementValue) {
        var ele = document.getElementById(arrayIndex);

        if (ele != null) {
            var atype = ele.getAttribute('type');
            if (atype == 'checkbox') {
                if (elementValue == 'on') {
                    ele.checked = true;
                }
            } else {
                ele.value = elementValue;
            }
        } else {
            var radios = document.getElementsByName(arrayIndex);
            for (var j = 0; j < radios.length; j++) {
                if (radios[j].value == elementValue) {
                    radios[j].checked = true;
                    break;
                }
            }
        }
    });
}
function tabgettable(table) {
    var data = {};
    var target = $(table + ' tr').not('thead tr');
    target.each(function (rowIndex, r) {
        var data2 = {};
        data2['setname'] = document.querySelector('#' + this.id + " [data-var='setname_" + this.id + "']").value;
        data2['file'] = document.querySelector('#' + this.id + " [data-var='value_" + this.id + "']").value;
        data[this.id] = data2;
    })
    return data;
}
function get_action_acc() {
    arr = {};
    a = document.querySelector('#sche_account').value;
    a2 = document.querySelector('#sche_nhiemvu').value;
    arr['accounts'] = a;
    arr['scripts'] = a2;
    return arr;
}
var c2 = {}
function checkedaccount() {
    $("#tab-account > form > table > tbody > tr").each(function (index, value) {
        b = this.querySelector('.label_name').innerText;
        if (this.querySelector("input.check_acc").checked) {
            c2[b] = b;
            $(this).addClass('bg-primary');
            document.getElementById("uname").value = b;

        } else {
            $(this).removeClass('bg-primary');
            delete c2[b];
        }
    })
    d = [];
    $.each(c2, function (value, key) {
        d.push(key);
    })
    document.querySelector('#sche_account').value = d.join(',');
}
function getvarstable(table) {
    var data = {};
    var target = $(table + ' tr').not('thead tr');
    target.each(function (rowIndex, r) {
        var data2 = {};
        data2['var_type'] = document.querySelector('#' + this.id + " [data-var='var_type_" + this.id + "']").value;
        data2['str_rdnum'] = document.querySelector('#' + this.id + " [data-var='str_rdnum_" + this.id + "']").value;
        data2['value'] = document.querySelector('#' + this.id + " [data-var='value_" + this.id + "']").value;
        data[this.id] = data2;
    })
    return data;
}
function gettime(type, next, time = '') {
    var date = new Date();
    if (time) {
        date = new Date(time);
    }
    if (type == 'hours') {
        date.setHours(date.getHours() + next);
        return date.getTime();
    } else if (type == 'date') {
        date.setDate(date.getDate() + next);
        return date.getTime();
    }
}
var light = null
function scheduler_setting() {
    var heck_sche = check_scheduler()
    if (heck_sche === true) {
        light = window.setInterval(scheduler_waiting, 100);
    } else {
        window.clearInterval(light);
    }
}
function add_get(file, tableid) {
    var table = table = document.querySelector(tableid);
    var next = table.rows.length;
    var lenvar = next - 1;
    var tabtd = document.querySelector(tableid + ' > tbody ');
    var clone = document.querySelector(tableid + ' > tbody > tr:last-child').cloneNode(true);
    var var_old = 'get_' + lenvar;
    var var_next = 'get_' + next;
    var re = new RegExp(var_old, "g");
    var clone2 = clone.innerHTML.replace(re, var_next);
    var doc = clone2.replaceAll('\n', '').replaceAll('    ', '');
    var newtr = stringToHTML(doc);
    newtr.id = var_next;
    newtr.innerHTML = doc;
    tabtd.appendChild(newtr);
    lenvar = lenvar + 1;
    update_data_var_get(file, tableid);
}
var lenvar = 0;k = {};
function checkedscript() {
    var arr2 = $('.nhiemvu_check:checked').map(function(){
        return this.id.replace('nhiemvu_','');
    }).get();
    
    document.querySelector("#sche_nhiemvu").innerHTML= arr2.join(',');
   return arr2;
}

function js_save_data() {
    update_data_var_get('var', '#tab_var');
    update_data_var_get('get', '#tab_get');
}

function add_data_get(file, table) {
    var next = lenvar + 1;
    var tabtd = document.querySelector(table + ' > tbody ');
    var clone = document.querySelector(table + ' > tbody > tr:last-child').cloneNode(true);
    var var_old = file + '_' + lenvar;
    var var_next = file + '_' + next;
    var re = new RegExp(var_old, "g");
    var clone2 = clone.innerHTML.replace(re, var_next);
    var doc = clone2.replaceAll('\n', '').replaceAll('    ', '');
    var newtr = stringToHTML(doc);
    newtr.id = var_next;
    newtr.innerHTML = doc;
    tabtd.appendChild(newtr);
    lenvar = lenvar + 1;
    update_data_var_get(file, table);
}
var stringToHTML = function (str) {
    var dom = document.createElement('tr');
    dom.innerHTML = str;
    return dom;
};
function del_data(file, table, key) {
    lenvar = lenvar - 1;
    document.getElementById(key).remove();
    update_data_var_get(file, table);
}
function set_disabled(t) {
    const boxes = document.querySelectorAll('.action-click');
    for (const box of boxes) {
        if (t == true) {
            box.classList.add("dis-clicked");
            box.setAttribute('disabled', '');
        } else if (t == false) {
            box.classList.remove("dis-clicked");
            box.removeAttribute('disabled');
        }
    }
}
function validateForm() {
    var name = document.getElementById("sche_name_script");
    var acc = document.getElementById("sche_date");
    var times = document.getElementById("sche_time");
    if (name.value == "") {
        name.focus();
        show_popup('Name Script Emty!');
        return false;
    }
    if (acc.value == "") {
        acc.focus();
        show_popup('Date Script Emty!');
        return false;
    }
    if (times.value == "") {
        show_popup('Time Script Emty!');
        times.focus();
        return false;
    }
}
function download(filename, text) {
    var element = document.createElement('a');
    element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
    element.setAttribute('download', filename);
    element.style.display = 'none';
    document.body.appendChild(element);
    element.click();
    document.body.removeChild(element);
}
function readTextFile(file) {
    var rawFile = new XMLHttpRequest();
    rawFile.open("GET", file, false);
    rawFile.onreadystatechange = function () {
        if (rawFile.readyState === 4) {
            if (rawFile.status === 200 || rawFile.status == 0) {
                var allText = rawFile.responseText;
            }
        }
    }
    rawFile.send(null);
}
function check_buid_run() {

    var lisld = document.getElementById("ldplayerbuilder").value;
    var textarea = document.getElementById("textarea-input").value;

    if (lisld != '' && textarea != '') {
        document.getElementById("run-build-script").removeAttribute("disabled");
        document.getElementById("addcodebuild").removeAttribute("disabled");

    }

}
$('#scriptbuildlist').on('change', function (e) {
    check = document.getElementById("scriptbuild").value = this.value;
    
    js_save_setting();
    load_script();
});
function code_select() {
    check = document.getElementById("scriptbuild").value;
    return check;
}
function actionsetting() {
    js_save_setting();
}
function formtabvar() {
    update_data_var_get('var', '#tab_var');
    update_data_var_get('get', '#tab_get');
}
function fchoice_list_script(value) {
    var newscript = "";
    var list = "";
    if (value == "new") {
        newscript = "block";
        list = "none";
    } else {
        newscript = "none";
        list = "block";
  
    }
    document.querySelector("select.scriptbuildlist").style = "display:" + list;
    document.querySelector("input.scriptbuild").style = "display:" + newscript;

}
function add_code_build() {
    var action = document.getElementById("addcode").value;
    var packag = document.getElementById("package_app").value;
    switch (action) {
        case "open":
            codeget = "open_app(em,'" + packag + "')";
            break;
        case "close":
            codeget = "close_app(em,'" + packag + "')";
            break;
        case "clear":
            codeget = "clear_app(em,'" + packag + "')";
            break;
        case "home":
            codeget = "go_home(em)";
            break;
        case "stopapp":
            codeget = "stop_app(em) # Stop all app";
            break;
        case "save":
            codeget = "SaveLine('acc/simple.txt','text')";
            break;
        case "load":
            codeget = "LoadFile('acc/simple.txt')";
            break;
        case "checkimage":
            codeget = "if check_img(em, 'demo/image', 3):\n  click(100,100)\nelse:\n click(200,200)";
            break;
        case "save_note":
            codeget = "time_date =str( datetime.now())\nup_note(em,time_date)";
            break;
        case "openbrowser":
            codeget = "open_browser(em,'https://www.google.com')";
            break;
        case "loop":
            codeget = 'for i in range(10):\n click(100,100)';
            break;    }
    document.getElementById("textarea-input").value += '\n' + codeget;
    document.getElementById("highlight-area").value += '\n' + codeget;
    var scrolltest = document.getElementById('textarea-input').scrollHeight;
    document.getElementById('textarea-input').scrollTop = scrolltest + 200;
    triggerlight();}
function load_var_data() {
    window.pywebview.api.load_data('var').then(function (number) {
        document.querySelector("#tab_var > tbody").innerHTML = '';
        number = sort_object(number);
        step = 0;
        lenvar = Object.keys(number).length;
        for (var i = 0; i < lenvar; i++) {
            var disabled = '';
            step = i + 1;
            var arrayIndex = "var_" + step
            var elementValue = number[arrayIndex];
            checked = '';
            if (elementValue['var_check'] == 'on') {
                checked = 'checked="checked"';
            }
            var select = '<tr id="' + arrayIndex + '" >\n<td style="width: 70px;display: inline-flex;">';
            if (arrayIndex != 'var_1') {
                select += '<button  value="' + arrayIndex + '" type="button" onclick="del_data(\'var\',\'#form_tab_var\',\'' + arrayIndex + '\')" class="bg-danger btn-dark del_line"  id="var_check_' + arrayIndex + '">X</button>';
            }
            select += arrayIndex + '   </td>   <td>   <select data-var="var_type_' + arrayIndex + '" id="var_type_' + arrayIndex + '" onchange="var_change(\'\',\'' + arrayIndex + '\',\'' + elementValue['value'] + '\',1)" style="width:80px;" >';
            select += ' <option value="file_var">File line</option>';
            select += ' <option value="file_path">File Path</option>';
            select += ' <option value="split_in_file_of" id="split_in_file_of">Split of var</option>';
            select += ' <option value="count">Count Number</option>';
            select += '<option value="random_number">Ran Number</option>';
            select += '<option value="random_str">Ran String</option>   ';
            select += '<option value="random_file">Ran in file</option>';
            select += '<option value="random_file_split">Ran file split</option>';
            select += ' <option value="step_in_file" id="step_in_file">Step File</option>';
            select += ' <option value="code2fa" id="code2fa">Code2fa</option>';
            select += ' </select> </td>';
            select += '<td><input type="number" min="0"  data-var="str_rdnum_' + arrayIndex + '" value="' + elementValue['str_rdnum'] + '"  id="str_rdnum_' + arrayIndex + '" style="width:40px" ></td>';
            select += '<td id="var_value_' + arrayIndex + '"> ' + var_change(elementValue['var_type'], arrayIndex, elementValue['value'], false);
            select += '</td></tr> ';
            $("#tab_var  tbody").append(select);
            document.querySelector('#var_type_' + arrayIndex).value = elementValue['var_type'];

            step += 1;
        };
        document.getElementById('var_type_var_1').setAttribute('disabled', '');
        document.getElementById('str_rdnum_var_1').setAttribute('disabled', '');
        document.getElementById('value_var_1').setAttribute('disabled', '');
    })
}
function var_change(var_type, varchange, value, type = false) {
    if (var_type == ''){
        var var_type = document.querySelector('#var_type_' + varchange).value;}
    var ele = '';
    if (var_type == 'split_in_file_of' || var_type == 'code2fa') {
        window.pywebview.api.load_data('var').then(function (number) {
            obj = Object();
            for (const [key, value] of Object.entries(number)) {
                obj[key] = key;
            }
            if (type == 1) {
                ele = dropDown('value_' + varchange, obj, '');
                document.querySelector('#var_value_' + varchange).innerHTML = ele;
            } else {
                ele = dropDown('value_' + varchange, obj, value);
                document.querySelector('#var_value_' + varchange).innerHTML = ele;
            }
        })
    } else if (var_type == 'random_file' || var_type == 'step_in_file' || var_type == 'split_in_file_of' || var_type == 'file_var') {
        window.pywebview.api.get_name('var', '.txt').then(function (number) {
            var obj = Object()
            for (const [key, value] of Object.entries(number)) {
                obj[value] = value;
            }
            if (type == 1) {
                ele = dropDown('value_' + varchange, obj, '');
                document.querySelector('#var_value_' + varchange).innerHTML = ele;
            } else {
                ele = dropDown('value_' + varchange, obj, value);
                document.querySelector('#var_value_' + varchange).innerHTML = ele;
            }
        });
    } else if (var_type == 'random_str') {
        obj = {
            'up': 'Upcase',
            'low': 'Lowcase',
            'hex': 'Hex'
        };
        if (type == 1) {
            ele = dropDown('value_' + varchange, obj, '');
            document.querySelector('#var_value_' + varchange).innerHTML = ele;
        } else {
            ele = dropDown('value_' + varchange, obj, value);
            return ele;
        }
    } else if (var_type == 'random_number') {
        valnumber = value.split(",");
        minv = valnumber[0];
        maxv = valnumber[1];
        ele = "<input value='" + value + "' type='hidden' data-var='value_" + varchange + "' id='value_" + varchange + "' name='value_" + varchange + "'>";
        ele += "<input value='" + minv + "' style=\" width: 40px; float: left;\" type='number' class='random-number'  onchange=\"random_change('" + varchange + "')\" min=0 id='minnumber_random_" + varchange + "'>";
        ele += "<input value='" + maxv + "' style=\" width: 40px; float: right;\"  type='number' class='random-number'  onchange=\"random_change('" + varchange + "')\"  min=0  id='maxnumber_random_" + varchange + "'>";
        if (type == 1) {
            document.querySelector('#var_value_' + varchange).innerHTML = '';
            document.querySelector('#var_value_' + varchange).innerHTML = ele;
        } else {
            return ele;
        }
    } else if (var_type == 'count') {
        ele = "<input value='" + value + "' type='hidden' data-var='value_" + varchange + "' id='value_" + varchange + "' name='value_" + varchange + "'>";
        if (type == 1) {
            document.querySelector('#var_value_' + varchange).innerHTML = ele;
        } else {
            return ele;
        }
    } else {
        ele = "<input type=\"text\" data-var=\"value_" + varchange + "\" id=\"value_" + varchange + "\"  value=\"" + value + "\" >";
        if (type == 1) {
            document.querySelector('#var_value_' + varchange).innerHTML = '';
            document.querySelector('#var_value_' + varchange).innerHTML = ele;
        } else {
            return ele;
        }
    }
}
function load_table_scheduler() {
    document.querySelector("#tablescheduler > table > tbody").innerHTML = '';
    window.pywebview.api.load_data('scheduler').then(function (number) {
        c = 1;
        var bodytale = "";
        $.each(number, function (arrayIndex, elementValue) {
            repeat = 'Run Once';
            if (elementValue["repeat"] == 'on') {
                rep = 'Repeat : <br\>';
                if (elementValue["choicrepeat"] == "sche_hour") {
                    repeat = rep + 'Every hour'
                } else if (elementValue["choicrepeat"] == "sche_days") {
                    type_repeat = 'Every Days';
                    repeat = rep + type_repeat;
                } else if (elementValue["choicrepeat"] == "sche_week") {
                    repeat = 'Days in Week (' + elementValue["days_list"] + ")";
                }
            }
            bodytale = "";
            bodytale += ' <tr id="' + arrayIndex + '"> ';
            bodytale += '   <td>';
            bodytale += '   <button  value="' + arrayIndex + '" type="button" onclick="js_del_data_key(\'data/scheduler\',\'' + arrayIndex + '\')" ';
            bodytale += '   class="bg-danger btn-dark del_line"  id="var_check_' + arrayIndex + '">X</button>         </td>             ';
            bodytale += '   <td> <a class="btn btn-sm my-btn btn-outline-dark" onclick="load_scheduler(\'' + arrayIndex + '\')">' + arrayIndex + '</a></td>';
            bodytale += '    <td><select name="turn" class="choice_scheduler" onchange="onchange_scheduler(this)" id="' + arrayIndex + '_turn"> ';
            bodytale += '    <option value="on">ON</option><option value="off">OFF</option></select></td>';
            bodytale += '    <td>' + repeat + '</td>';
            bodytale += '    <td><label for="' + arrayIndex + '">' + elementValue['sche_date'] + ' ' + elementValue['sche_time'] + '</label> ';
            bodytale += '    <input type="hidden" class="_repeat"     value="' + elementValue['repeat'] + '">';
            bodytale += '   <input type="hidden" class="_choicrepeat" value="' + elementValue['choicrepeat'] + '">';
            bodytale += '    <input type="hidden" class="_sche_date"  value="' + elementValue['sche_date'] + '">';
            bodytale += '    <input type="hidden" class="_sche_time"  value="' + elementValue['sche_time'] + '">';
            bodytale += '    <input type="hidden" class="_days_list"  value="' + elementValue['days_list'] + '">';
            bodytale += '    <input type="hidden" class="_runned"     value="' + elementValue['runned'] + '">';
            bodytale += '    </td>          ';
            bodytale += '    </tr>';

            $("#tab_scheduler table tbody").append(bodytale);

            c += 1;
            document.querySelector('#' + arrayIndex + '_turn').value = elementValue['turn'];
        });
    })
}
function addaccount() {
    uname = document.getElementById("uname").value;
    server = document.getElementById("note").value;
    window.pywebview.api.add_account('accounts', uname, false, server)
    floadaccounts();
}
function js_save_setting() {
    ele = document.querySelectorAll('[name]');
    ajs = {};
    ele.forEach((c) => {
        if (c.type == 'checkbox') {
            if (c.checked) {
                ajs[c.name] = 'on';
            } else {
                ajs[c.name] = 'off';
            }
        } else if (c.type == 'radio') {
            if (c.checked) {
                ajs[c.name] = c.value;
            }
        } else if (c.tagName == 'select') {
            if (c.selected) {
                ajs[c.name] = c.value;
            }
        } else {
            ajs[c.name] = c.value;
        }
    }
    );
    delete ajs['sche_name_script'];
    window.pywebview.api.save_data('settings', ajs);
}
function js_del_scripts(name) {
    document.getElementById("script_" + name).remove();
    window.pywebview.api.action(['removescript', name]).then(function (number) {
        load_select_cripts();
        load_tables_cripts();
    });

}
function load_tables_cripts() {
    var arr = checkedscript();
    
    var checked ='';
    document.querySelector("#tablescripts > table > tbody").innerHTML = '';
    window.pywebview.api.get_path_name("scripts").then(function (number) {
        var tablebody = "";

        $.each(number, function (arrayIndex, elementValue) {
            checked ='';
      
            tablebody += "<tr id='script_" + elementValue + "'>";
            tablebody += "<td> <label for=\"nhiemvu_" + elementValue + "\" class='check_nhiemvu_tab'  onclick=\"checkedscript() \">";
            tablebody += " <input type=\"checkbox\"  id=\"nhiemvu_" + elementValue + "\"  class='form-check-inline nhiemvu_check'>" + elementValue + "</label>";
            tablebody += "</td>";
            tablebody += "<td> ";
            tablebody += "<button type=\"button\" onclick=\"js_del_scripts('" + elementValue + "')\" ";
            tablebody += "class=\"bg-danger btn-dark del_line\" >x</button></td>";
            tablebody += " </td>";
            tablebody += " </tr>";

        });
        $("#tablescripts table > tbody").append(tablebody);

        for (let index = 0; index < arr.length; index++) {
            const element = arr[index];
            document.getElementById(element).checked = true;
            
        }
            

        checkedscript();    })

}
function load_get_data() {
    window.pywebview.api.load_data('get').then(function (number) {
        document.querySelector("#tab_get > tbody").innerHTML = '';
        number = sort_object(number);
        step = 0;
        lenvar = Object.keys(number).length;
        var select = '';
        for (var i = 0; i < lenvar; i++) {
            step = i + 1;
            var arrayIndex = "get_" + step;
            var elementValue = number[arrayIndex];
            checked = '';
            select = '';
            select = '<tr id="' + arrayIndex + '" >';
            select += '   <td style="width: 70px;display: inline-flex;">';
            select += '   <button  value="' + arrayIndex + '" type="button"  onclick="del_data(\'get\',\'#form_tab_get\',\'' + arrayIndex + '\')"  ';
            select += '   class="bg-danger btn-dark del_line"  id="var_check_' + arrayIndex + '">X</button>' + arrayIndex + '</td> ';
            select += '  <td><input type="text"  data-var="setname_' + arrayIndex + '" value="' + elementValue['setname'] + '" ';
            select += '   id="setname_' + arrayIndex + '" style="width:70px"></td>';
            select += '   <td><input type="text" data-var="value_' + arrayIndex + '" id="value_' + arrayIndex + '"  value="' + elementValue['file'] + '" ';
            select += '  style="width:130px"></td>  </tr> '
            $("#tab_get  tbody").append(select);
            step += 1;
        };
    })
}
function createclone() {
    set_disabled(true); window.pywebview.api.action('clone'); setTimeout(() => { set_disabled(false); }, 1000);
}
function action_all(action) {
    set_disabled(true); window.pywebview.api.action(action); setTimeout(() => { set_disabled(false); }, 850);

}

function js_del_data_key(file, key) {
    document.getElementById("" + key).remove();
    window.pywebview.api.del_data_key(file, key);
}
function update_data_var_get(file, table) {
    if (file == 'var') {
        var data = getvarstable(table);
        window.pywebview.api.save_data(file, data);
    } else {
        var data = tabgettable(table);
        window.pywebview.api.save_data(file, data);
    }
}
function clear_all() {
    window.pywebview.api.save_data('accounts', {});
    floadaccounts();
}
function add_scheduler() {
    arr = document.querySelector('#lichnhiemvu');
    ele = arr.querySelectorAll('[name]');
    ajs = {};
    sche_day = [];

    ele.forEach((c) => {
        if (c.type == 'checkbox') {
            if (c.checked) {
                ajs[c.name] = 'on';
                if (c.name.includes("sche_day")) {
                    sche_day.push(c.value);
                }
            } else {
                ajs[c.name] = 'off';
            }
        } else if (c.type == 'radio') {
            if (c.checked) {
                ajs[c.name] = c.value;
            }
        } else {
            ajs[c.name] = c.value;
        }
    });
    if (sche_day.length > 0) {
        ajs['days_list'] = sche_day;
    }
    acc = [];
    scripts = [];
    var datetime = document.getElementById("sche_date").value;
    var hoursetime = document.getElementById("sche_time").value;
    ajs['accounts'] = get_action_acc()['accounts'];
    ajs['scripts'] = get_action_acc()['scripts'];
    fulltime = datetime + ' ' + hoursetime;
    var name = document.getElementById("sche_name_script");
    if (name.value == '') {
        name.focus();
        return;
    }
    ajs['turn'] = 'off';
    ajs['runned'] = [];
    window.pywebview.api.update_data('scheduler', name.value, ajs);
    setTimeout(() => { load_table_scheduler(); }, 500);
}
function runaction(id) {
    js_save_data();
    set_disabled(true);
    data = get_action_acc();
    window.pywebview.api.run_action(data).then(function (params) {
        setTimeout(() => { set_disabled(false); }, 850);
    });

}
function stop_all() {
    window.pywebview.api.stopall();
    window.pywebview.api.action('stopall');
}

function update_ld() {
    set_disabled(true);
    window.pywebview.api.check_path();
    setTimeout(() => { set_disabled(false); }, 850);

}
function stopaction() {
    // window.pywebview.api.action_st('stop');
    optionNames = get_action_acc()['accounts'];
    window.pywebview.api.action(['stopacc', optionNames]);
}function test_script() {
    var ld = document.getElementById("ldplayerbuilder").value;
    coderun = ['runstest', ld]
    window.pywebview.api.action(coderun);
}
function reg_acc() {
    var code = document.getElementById("sche_nhiemvu").value;
    var loop = document.getElementById("sche_loop_number").value;
    coderun = ['regacc', code, loop]
    window.pywebview.api.action(coderun);
}

function onchange_scheduler(ele) {
    var param = ele.getAttribute('name');
    var value = ele.value;
    key = ele.id.replace('_turn', '');
    if (value == 'on') {
        window.pywebview.api.action(['schedule']);
    }

    update_scheduler('scheduler', key, param, value);
}
function update_scheduler(file, key, param, value) {
    window.pywebview.api.load_data('scheduler').then(function (scheduler) {
        scheduler[key][param] = value;
        window.pywebview.api.save_data(file, scheduler);
    })
}
function load_scheduler(key) {
    window.pywebview.api.load_data('scheduler').then(function (scheduler) {
        var data = scheduler[key];
        document.getElementById("sche_name_script").value = data['sche_name_script'];
        document.getElementById("sche_date").value = data['sche_date'];
        document.getElementById("sche_time").value = data['sche_time'];
        document.getElementById("sche_step").value = data['sche_step'];
        document.getElementById("repeat").checked = false;
        if (data['repeat'] == 'on') {
            document.getElementById("repeat").click();
        }
        clear_uncheck('input.sche_day');
        $.each(data['days_list'], function (k, v) {
            document.querySelector(".sche_day[value='" + v + "']").checked = true;
        });
        acc = data['accounts'].split(',');
        clear_uncheck('input.check_acc');
        $.each(acc, function (k, v) {
            var element = document.getElementById("check" + v);
            if (typeof (element) != 'undefined' && element != null) {
                document.getElementById("check" + v).click();
            }
        });
        clear_uncheck('input.nhiemvu_check');
        scripts = data['scripts'].split(',');
        $.each(scripts, function (k1, v1) {
            var element = document.getElementById("nhiemvu_" + v1);
            if (typeof (element) != 'undefined' && element != null) {
                document.getElementById("nhiemvu_" + v1).click();
            }
        });
    })
}function loadallfileacc(path = '', getfile = '') {
    if (path == '') {
        path = document.getElementById("folderacc").value;
    }

    document.getElementById("select_file_acc").innerHTML='';
    var selelect=''
    window.pywebview.api.get_name(path, '.txt').then(function (number) {
        $.each(number, function (arrayIndex, elementValue) {
            var regex = /.*csv|.*txt/;
            if (elementValue.match(regex)) {
                selelect=''
                if( elementValue == getfile) {selelect='selected';}
                $("#select_file_acc").append(' <option value="' + elementValue + '" ' + selelect + '>' + elementValue + '</option>');
            }
        });

    })

}
function ld_list() {
    var varldplayer = document.getElementById("ldselect");
    var ldplayerbuilder = document.getElementById("ldplayerbuilder");
    var selected = ''
    set_disabled(true);
    window.pywebview.api.list_ld().then(function (data) {

        if (Object.keys(data).length > 0) {
            if (data.name.length > 0) {
                ldplayerbuilder.innerHTML = '';
                $.each(data.name, function (arrayIndex, elementValue) {
                    $("#ldplayerbuilder").append('<option value="' + elementValue + '" >' + elementValue + '</option>');

                });
                if (ldplayerbuilder.value) {
                    ldplayerbuilder.value = ldplayerbuilder.value;
                }

            }
            if (data.running.length > 0) {
                varldplayer.innerHTML = '';
                varldplayer.innerHTML = '<option value="all" >All</option>';

                $.each(data.running, function (arrayIndex, elementValue1) {

                    $("#ldselect").append('<option value="' + elementValue1 + '" >' + elementValue1 + '</option>');

                });
                if (varldplayer.value) {
                    document.getElementById("ldselect").value = varldplayer.value;
                } else {
                    document.getElementById("ldselect").value = "";
                }

            }        }
    })
    setTimeout(() => { set_disabled(false); }, 850);
    check_buid_run();
    load_package(varldplayer.value);}
function load_apk(path = '') {
    if (path == '') {
        path = document.getElementById("folderapk").value;
    }
    $("#list_file_apk").html('');
    window.pywebview.api.get_name(path, '.apk').then(function (number) {
        var i = 0;
        $.each(number, function (arrayIndex, elementValue) {
            var regex = /.apk/;
            if (elementValue.match(regex)) {
                $("#list_file_apk").append('<label for="' + elementValue + '"><input type="checkbox" class="select_apk form-check-inline" id="' + elementValue + '" data-value="' + elementValue + '">' + elementValue + '</label>');
                i = i + 1;
            }
        });
    })
}
function load_package(ld) {
    var varld = document.getElementById('ldselect').value;
    var varld2 = document.getElementById('ldplayerbuilder').value;
    console.log(varld,ld,varld2);
    window.pywebview.api.load_package(ld).then(function (number) {
        console.log(number);
        document.getElementById("list_package").innerHTML = '';
        document.getElementById("package_app").innerHTML = '';
        if (number != '') {

            $.each(number, function (arrayIndex, elementValue) {
                $("#list_package").append('<label for="' + elementValue + '" id="package_' + elementValue + '"><input type="checkbox" class="select_package form-check-inline" id="' + elementValue + '" data-value="' + elementValue + '"> ' + elementValue + '</label>');

                $("#package_app").append('<option value="' + elementValue + '" >' + elementValue + '</option>');
            });            if (varld) { document.getElementById('ldselect').value = varld; }
            if (varld2) { document.getElementById('ldplayerbuilder').value = varld2; }
        }
        var packages = ['com.android.storagemanager', 'com.android.browser', 'com.android.settings', 'com.android.providers.media'];
        for (let index = 0; index < packages.length; index++) {
            const element = packages[index];
            $("#package_app").append('<option value="' + element + '" >' + element + '</option>');

        }

    })
    setTimeout(() => { check_buid_run(); }, 850);
}
function install_app() {
    var lisapk = document.getElementById("list_file_apk");
    var allapk = lisapk.querySelectorAll('.select_apk');
    var path = document.getElementById("folderapk").value;
    var ld = document.getElementById("ldselect").value;
    apks = [];
    $.each(allapk, function (arrayIndex, ele) {
        if (ele.checked) {
            apks.push(path + '\\' + ele.id);
        }
    })
    acction = ["installapp", apks.join(','), ld]
    window.pywebview.api.action(acction);
}
function uninstall_app() {
    var lisapk = document.getElementById("list_package");
    var allapk = lisapk.querySelectorAll('.select_package');
    var ld = document.getElementById("ldselect").value;
    apks = [];
    $.each(allapk, function (arrayIndex, ele) {
        if (ele.checked) {
            apks.push(ele.id);
            document.getElementById("package_" + ele.id).remove();
        }
    })
    acction = ["removeallapp", apks.join(','), ld]
    window.pywebview.api.action(acction);
}
function loadacc() {

    var path = document.getElementById("folderacc").value;
    var filename = document.getElementById("select_file_acc").value;
    document.getElementById("value_var_1").value = path + '/' + filename;
    window.pywebview.api.save_acc_from_file(path + '/' + filename).then(function (codeget) {
        floadaccounts();
        update_data_var_get('var', '#tab_var');
    });

    c2 = {}
}

function run_build_script() {
    set_disabled(true);
    check = code_select();
    if (check == "") {
        document.querySelector(".scriptbuild").focus();
        return;
    }
    var $textarea = document.getElementById('textarea-input');
    var ldplayer= document.getElementById('ldplayerbuilder').value;
    window.pywebview.api.build_script('start',ldplayer);
    window.pywebview.api.load_code(check).then(function (codeget) {
        document.getElementById("textarea-input").value = codeget;
        document.getElementById("highlight-area").value = codeget;
        triggerlight();
        setTimeout(() => { set_disabled(false); }, 850);
    })
}
function triggerlight() {
    var $textarea = document.getElementById("textarea-input");
    var $highlight = document.getElementById("highlight-area");
    var tokens = tokenize($textarea.value);
    $highlight.innerHTML = '';
    for (var i = 0; i < tokens.length; i++) {
        var token = tokens[i];
        var span = document.createElement('span');
        span.className = 'highlight-' + token.type;
        span.innerText = token.value;
        $highlight.appendChild(span);
    }
    var lines = $textarea.value.split('\n');
    if (lines[lines.length - 1] === '') {
        var br = document.createElement('br');
        $highlight.appendChild(br);
    }
    $highlight.scrollTop = $textarea.scrollTop;
}

function logging_debug() {
    setInterval(() => {
        window.pywebview.api.load_file_txt('coderun').then(function (codeget2) {
            if (codeget2 != '') {
                var $textarea = document.getElementById("textarea-input");
                var $highlight = document.getElementById("highlight-area");
                var triggerHighlight2 = function () {
                    var tokens = tokenize($textarea.value);
                    $highlight.innerHTML = '';
                    for (var i = 0; i < tokens.length; i++) {
                        var token = tokens[i];
                        var span = document.createElement('span');
                        span.className = 'highlight-' + token.type;
                        span.innerText = token.value;
                        $highlight.appendChild(span);
                    }
                    var lines = $textarea.value.split('\n');
                    if (lines[lines.length - 1] === '') {
                        var br = document.createElement('br');
                        $highlight.appendChild(br);
                    }
                    $highlight.scrollTop = $textarea.scrollTop;
                };
                var tabCode = 9;
                var leftParenthesisCode = 40;
                $textarea.addEventListener('keydown', function (event) {
                    triggerlight();
                    switch (event.keyCode) {
                        case tabCode:
                            event.preventDefault();
                            this.value += '    ';
                            break;
                    }
                });
                $textarea.value += '\n' + codeget2;
                $highlight.value += '\n' + codeget2;
                $textarea.addEventListener('input', triggerHighlight2);
                $textarea.addEventListener('scroll', function (event) {
                    $highlight.scrollTop = this.scrollTop;
                });
                window.pywebview.api.save_code_run();
                triggerHighlight2();

                var scrolltest = document.getElementById('textarea-input').scrollHeight;
                document.getElementById('textarea-input').scrollTop = scrolltest + 200;

            }
        })
    }, 1000);
}

function load_script() {
    check = code_select()
    window.pywebview.api.load_code(check).then(function (codeget) {
        document.getElementById("textarea-input").value = codeget;
        document.getElementById("highlight-area").value = codeget;
        triggerlight();
        load_tables_cripts();
        load_select_cripts();
    })
    setTimeout(() => { check_buid_run(); }, 500);

}
function update_script() {
    set_disabled(true);
    check = code_select();
    code = document.getElementById("textarea-input");
    window.pywebview.api.save_code(check, code.value);
    setTimeout(() => { set_disabled(false); }, 850);
}
function setDarkTheme() {
    document.body.style.color = '#ffffff';
    document.body.style.backgroundColor = '#333333';
}
$data_check = {}
setInterval(() => {
    showstartus = [
        ['Waiting...', 'text-waiting'], ['Starting !', 'text-starting'], ['Running!', 'text-running'], ['Run Done!', 'text-done'], ['Stop!', 'text-stop'], ['Error', 'text-error']
    ];
    window.pywebview.api.load_data('accounts').then(function (data) {

        if (JSON.stringify($data_check) !== JSON.stringify(data)) {

            for (var i in data) {
                var uname = i;
                var check = data[i]['running'];
                var note = data[i]['note'];
                $("#" + uname).attr('title',data[i]['ldplayer'])
                $("#" + uname).attr('tooltip',data[i]['ldplayer'])
                if (check > 0) {
                    var a = $("#accrunning" + uname);
                    a.attr('class', '');
                    a.html(showstartus[check - 1][0]);
                    a.addClass(showstartus[check - 1][1]);
                    if (note) {
                        var a = $("#accnote" + uname).html(note);
                    }
                }
            }
            $data_check = data;
        }
    })
}, 1000);
function stop_build_script() {
    var ldplayer= document.getElementById('ldplayerbuilder').value;
    window.pywebview.api.build_script('stop',ldplayer);
    setTimeout(() => { set_disabled(false); }, 850);

}
logging = document.getElementById("logging");
function load_select_cripts() {
    $("select.scriptbuildlist").html('');
    $("select.export_script").html('');
    window.pywebview.api.get_path_name("scripts").then(function (number) {
        $.each(number, function (arrayIndex, elementValue) {
            $("select.scriptbuildlist").append('<option value="' + elementValue + '">' + elementValue + '</option>');
            $("select.export_script").append('<option value="' + elementValue + '">' + elementValue + '</option>');

        });
    })
    window.pywebview.api.load_data("settings").then(function (number2) {
        document.getElementById("scriptbuildlist").value = number2['scriptbuildlist'];
    })
}
setInterval(() => {
    var codestring = '';
    pywebview.api.load_file_txt('logging').then(function (vallog) {
        var class_log = '';
        if (vallog != '') {
            codeget = vallog.split("\n");
            codeget.forEach(function (codeget2) {
                if (codeget2.indexOf("INFO") > 0) {
                    class_log = 'text-success';
                    codestring = codeget2.replace("INFO", "");
                } else if (codeget2.indexOf("WARNING") > 0) {
                    class_log = 'text-waiting';
                    codestring = codeget2.replace("WARNING", "");
                }
                else if (codeget2.indexOf("ERROR") > 0) {
                    class_log = 'text-error';
                } else if (codeget2.indexOf("DEBUG") < 0) {
                    class_log = 'text-starting';
                    codestring = codeget2.replace("DEBUG", "");
                }

                string = "<p class='" + class_log + "'>" + codestring + "</p>";
                $("#logging").prepend(string);
               
            })
        }
        pywebview.api.save_code_run('logging');
    })
}, 2000);
setTimeout(() => {
    window.pywebview.api.load_data('settings').then(function (number) {
        add_thread();

        load_get_data();
        load_data_js(number);
        floadaccounts();
        load_var_data();
        load_tables_cripts();
        load_select_cripts();
        load_table_scheduler();
        load_apk();
        logging_debug();
        start_app();
        loadallfileacc(number['folderacc'], number['select_file_acc']);
        window.pywebview.api.action('runstart');
        document.getElementById("run-build-script").setAttribute("disabled", true);
        document.getElementById("addcodebuild").setAttribute("disabled", true);
        document.getElementById('inline').addEventListener('change', changegrid);
        document.body.addEventListener('change', js_save_setting);
        document.getElementById('form_tab_var').addEventListener('change', formtabvar);
        document.getElementById('textarea-input').addEventListener('keyup', triggerlight);
        document.getElementById("select_file_acc").value =  number['select_file_acc'];
        myScript();
        load_script();
        load_list_var();
    })}, 1200);
document.getElementById("folderacc").addEventListener("change", (event) => {
    setTimeout(() => { loadallfileacc(); }, 300);
})
function start_app() {
    window.addEventListener('load', function () {
        loadpage();
    })
}

function changegrid() {
    window.pywebview.api.action('grid');
}
function floadaccounts() {
    $("#tab-account table tbody").remove();
    $("#tab-account table").append('<tbody></tbody>');
    showstartus = [
        ['Waiting...', 'text-waiting'], ['Starting !', 'text-starting'], ['Running!', 'text-running'], ['Run Done!', 'text-done'], ['Stop!', 'text-stop'], ['Error', 'text-error']
    ]
    window.pywebview.api.load_data('accounts').then(function (number) {
        count = 1
        var tablebody = '';
        var text = ''; var addClass = '';
        var check = '';
        $.each(number, function (arrayIndex, elementValue) {
            text = '';
            addClass = '';
            tablebody = '';
            tablebody += ' <tr id="' + arrayIndex + '" onclick="checkedaccount()" title="' + elementValue['ldplayer'] + '" tooltip="' + elementValue['ldplayer'] + '"  > ';
            tablebody += ' <td >' + count + '</td>';
            tablebody += '<td> <label for="check' + arrayIndex + '" > <input type="checkbox"  id="check' + arrayIndex + '"  class="form-check-inline check_acc" >  </label> ';
            tablebody += ' </td> ';
            tablebody += ' <td><label for="check' + arrayIndex + '" class="label_name">' + arrayIndex + '</label>   </td>';
            check =elementValue['running'] 
            if (check > 0) {
                text =showstartus[check - 1][0];
                addClass =showstartus[check - 1][1];

            }       
            tablebody += '<td><label class="' + addClass + '" for="check' + arrayIndex + '" id="accrunning' + arrayIndex + '">' + text + '</label> </td>';
            tablebody += '<td><label for="check' + arrayIndex + '" id="accnote' + arrayIndex + '">' + elementValue['note'] + '</label></td>';
            tablebody += ' <td> <button type="button" onclick="js_del_data_key(\'data/accounts\',\'' + arrayIndex + '\')" ';
            tablebody += '  class="bg-danger btn-dark del_line" >x</button></td>';
            tablebody += '  </tr>';
            $("#tab-account table tbody").append(tablebody);

            count += 1
        });
    })
}
function logout() {
    window.pywebview.api.logout();
}
function scrollcodebuild(event) {
    document.getElementById("highlight-area").scrollTop = document.getElementById("textarea-input").scrollTop;

}

function myScript() {
    $textarea = document.querySelector('#textarea-input');
    $highlight = document.querySelector('#highlight-area');
    var triggerHighlight = function () {
        var tokens = tokenize($textarea.value);
        $highlight.innerHTML = '';
        for (var i = 0; i < tokens.length; i++) {
            var token = tokens[i];
            var span = document.createElement('span');
            span.className = 'highlight-' + token.type;
            span.innerText = token.value;
            $highlight.appendChild(span);
        }
        var lines = $textarea.value.split('\n');
        if (lines[lines.length - 1] === '') {
            var br = document.createElement('br');
            $highlight.appendChild(br);
        }
        $highlight.scrollTop = $textarea.scrollTop;
    };
    if ($textarea) {
        $textarea.addEventListener('input', triggerHighlight);

        $textarea.addEventListener('scroll', function (event) {
            $highlight.scrollTop = this.scrollTop;
        });
    }
    var tabCode = 9;
    var leftParenthesisCode = 40;
    $textarea.addEventListener('keydown', function (event) {
        switch (event.keyCode) {
            case tabCode:
                event.preventDefault();
                this.value += '    ';
                break;
        }
    });};var menuDefinition = [
    {
        html: `<span>Selected Accounts</span><span>From:
   <input style="width: 40px" name="slt_from" onclick="checkup()" onchange="checkup()" class="slt_from" type="number" min="1" value="1"/>to
   <input  class="slt_to" style="width: 40px"  name="slt_to"  min="5"  value="5" type="number"/>
 <input type="button" onclick="selectaccouts()" value="OK">
 </span>
 <span>Step:
   <input style="width: 40px" name="step"  onchange="btnstep()" class="step" type="number" min="1" value="5"/>
 <input type="button" onclick="btnnext()" value="Next">
 </span> `, disabled: true
    },
]
ctxmenu.attach(".tab-account", menuDefinition);
function selectaccouts() {

    var from = document.querySelector("input[name='slt_from']").value;
    var to = document.querySelector("input[name='slt_to']").value;
    $(".check_acc").each(function () {
        this.checked = false;
    });
    var idcheck='';
    $(".check_acc").each(function (index, value) {
        if (index + 1 >= from && index < to) {
            if (idcheck =='')
                idcheck =this.id;
            this.checked = true;
        }
    });
    location.href = '#' + idcheck;
    nextstep = document.querySelector("input[name='step']").value;
    localStorage.setItem('min', from);
    localStorage.setItem('max', to);
    localStorage.setItem('step', nextstep);

    var menuDefinition = [
        {
            html: `<span>Selected Accounts</span><span>From:
       <input style="width: 40px" name="slt_from" onclick="checkup()" onchange="checkup()" class="slt_from" type="number" min="1" value="${from.toString()}"/>to
       <input  class="slt_to" style="width: 40px"  name="slt_to"  min="2"  value="${to.toString()}" type="number"/>
     <input type="button" onclick="selectaccouts()" value="OK">
     </span>
     <span>Step:
       <input style="width: 40px" name="step"  onchange="btnstep()" class="step" type="number" min="1" value="${nextstep.toString()}"/>
     <input type="button" onclick="btnnext()" value="Next">
     </span> `, disabled: true
        },
    ]

    ctxmenu.update(".tab-account", menuDefinition);

    checkedaccount();
}

function btnstep() {
    var min = document.querySelector("input[name='slt_from']");
    var max = document.querySelector("input[name='slt_to']");
    var vstep = document.querySelector("input[name='step']").value;    max.value = Number(min.value) + Number(vstep)-1}
function btnnext() {
    var min = document.querySelector("input[name='slt_from']");
    var max = document.querySelector("input[name='slt_to']");
    var vstep = document.querySelector("input[name='step']").value;
    min.value = Number(min.value) + Number(vstep) ;
    max.value = Number(max.value) + Number(vstep);
    selectaccouts();
}
function checkup() {
    var slt_from = document.querySelector("input[name='slt_from']").value;
    var slt_to = document.querySelector("input[name='slt_to']").value;
    var vstep = document.querySelector("input[name='step']").value;
    var setto = Number(slt_from) + Number(vstep)-1;

    document.querySelector("input[name='slt_to']").setAttribute("min", setto);
    document.querySelector("input[name='slt_to']").value = setto;
}
function export_folder(pathexp) {
    if (pathexp == 'data') {
        folderpath = 'data';
        window.pywebview.api.export_folder(folderpath);
    }
    else if (pathexp == 'scripts') {
        var file_scripts = document.querySelector("#file_exp_scripts").value;
        folderpath = 'scripts/' + file_scripts
        window.pywebview.api.export_folder(folderpath);
    } else if (pathexp == 'backup') {
        window.pywebview.api.backup();
    }

}
function import_folder(pathexp) {

    window.pywebview.api.import_folder();

}
function add_path(path) {
    window.pywebview.api.get_path().then(function (rpath) {
        if (rpath != ''){
        if (path == 'acc') {
            document.querySelector("#folderacc").value = rpath[0];
            loadallfileacc(rpath[0]);
            setTimeout(() => { document.querySelector("#select_file_acc").value = rpath[1]; }, 850);
            
            
        } else {
            document.querySelector("#folderapk").value = rpath[0];
            load_apk();
        }}

    })
}
function save_var(){
   var data =document.querySelector('#editvar').value 
   var choice_filevar = document.querySelector('#choice_filevar').value ;
   var filename = "";
   if (choice_filevar == "new") {   
        filename = document.querySelector('#varnew').value ;
   } else {
        filename = document.querySelector('#varlist').value ;
   }
    window.pywebview.api.save_file_txt(data,filename,'var').then(function (number) {
        select      = document.querySelector('#varlist');
        option = document.createElement( 'option' );
        option.value = option.text = filename;
        select.add( option );
});
}
function load_var(){
    var value = document.querySelector('#choice_filevar').value ;
    var filename = "";
    if (value == "new") {   
         filename = document.querySelector('#varnew').value ;
    } else {
         filename = document.querySelector('#varlist').value ;
     
    }

    window.pywebview.api.load_file_txt(filename, 'var').then(function (number) {
        document.querySelector('#editvar').value = number;
        
    });

    
}
function del_var(){
    filename = document.querySelector('#varlist').value ;

    window.pywebview.api.del_txt(filename).then(function (number) {
        document.querySelector("#varlist > option[value='"+filename+"']").remove()
        load_list_var();
    });
    
}

function load_list_var(selected=''){
    var ele = '';
    document.querySelector('#varselect').innerHTML ='';
    window.pywebview.api.get_name('var', '.txt').then(function (number) {
        var obj = Object();

        for (const [key, value] of Object.entries(number)) {
            const filetext=value.replace('.txt','');
            obj[filetext] = filetext;
        }
        ele = dropDown('varlist' , obj, selected);
        document.querySelector('#varselect').innerHTML = ele;
        document.querySelector('#varlist').setAttribute('onchange','load_var()');
        document.querySelector('#varlist').setAttribute('name','varlist');

        load_var();
    });}function fchoice_list_var(value) {
    var newscript = "";
    var list = "";
    if (value == "new") {
        newscript = "block";
        list = "none";
        document.querySelector('#editvar').value ='';
        document.querySelector('#varnew').value ='';

    } else {
        newscript = "none";
        list = "block";
    }
    document.querySelector("#varlist").style = "display:" + list;
    document.querySelector("#delvar").style = "display:" + list;
    document.querySelector("#varnew").style = "display:" + newscript;
    document.querySelector("#addnew").style = "display:" + newscript;

}