/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.event;

import org.piccolo2d.event.PInputEvent;

public class PInputEventFilter {
    public static final int ALL_MODIFIERS_MASK = 63;
    private int andMask;
    private int orMask;
    private int notMask;
    private short clickCount = (short)-1;
    private boolean marksAcceptedEventsAsHandled = false;
    private boolean acceptsAlreadyHandledEvents = false;
    private boolean acceptsKeyPressed = true;
    private boolean acceptsKeyReleased = true;
    private boolean acceptsKeyTyped = true;
    private boolean acceptsMouseClicked = true;
    private boolean acceptsMouseDragged = true;
    private boolean acceptsMouseEntered = true;
    private boolean acceptsMouseExited = true;
    private boolean acceptsMouseMoved = true;
    private boolean acceptsMousePressed = true;
    private boolean acceptsMouseReleased = true;
    private boolean acceptsMouseWheelRotated = true;
    private boolean acceptsFocusEvents = true;

    public PInputEventFilter() {
        this.acceptEverything();
    }

    public PInputEventFilter(int andMask) {
        this();
        this.andMask = andMask;
    }

    public PInputEventFilter(int andMask, int notMask) {
        this(andMask);
        this.notMask = notMask;
    }

    public boolean acceptsEvent(PInputEvent event, int type) {
        boolean aResult = false;
        int modifiers = 0;
        if (!event.isFocusEvent()) {
            modifiers = event.getModifiers();
        }
        if (event.isHandled() && !this.acceptsAlreadyHandledEvents) {
            return false;
        }
        if (modifiers != 0) {
            if ((modifiers & this.andMask) != this.andMask || (modifiers & this.notMask) != 0) {
                return false;
            }
            if (this.orMask != 63 && (modifiers & this.orMask) == 0) {
                return false;
            }
        }
        if (event.isMouseEvent() && this.clickCount != -1 && this.clickCount != event.getClickCount()) {
            return false;
        }
        switch (type) {
            case 401: {
                aResult = this.getAcceptsKeyPressed();
                break;
            }
            case 402: {
                aResult = this.getAcceptsKeyReleased();
                break;
            }
            case 400: {
                aResult = this.getAcceptsKeyTyped();
                break;
            }
            case 500: {
                aResult = this.getAcceptsMouseClicked();
                break;
            }
            case 506: {
                aResult = this.getAcceptsMouseDragged();
                break;
            }
            case 504: {
                aResult = this.getAcceptsMouseEntered();
                break;
            }
            case 505: {
                aResult = this.getAcceptsMouseExited();
                break;
            }
            case 503: {
                aResult = this.getAcceptsMouseMoved();
                break;
            }
            case 501: {
                aResult = this.getAcceptsMousePressed();
                break;
            }
            case 502: {
                aResult = this.getAcceptsMouseReleased();
                break;
            }
            case 0: 
            case 1: {
                aResult = this.getAcceptsMouseWheelRotated();
                break;
            }
            case 1004: 
            case 1005: {
                aResult = this.getAcceptsFocusEvents();
                break;
            }
            default: {
                throw new RuntimeException("PInputEvent with bad ID");
            }
        }
        if (aResult && this.getMarksAcceptedEventsAsHandled()) {
            event.setHandled(true);
        }
        return aResult;
    }

    public void acceptAllClickCounts() {
        this.clickCount = (short)-1;
    }

    public void acceptAllEventTypes() {
        this.acceptsKeyPressed = true;
        this.acceptsKeyReleased = true;
        this.acceptsKeyTyped = true;
        this.acceptsMouseClicked = true;
        this.acceptsMouseDragged = true;
        this.acceptsMouseEntered = true;
        this.acceptsMouseExited = true;
        this.acceptsMouseMoved = true;
        this.acceptsMousePressed = true;
        this.acceptsMouseReleased = true;
        this.acceptsMouseWheelRotated = true;
        this.acceptsFocusEvents = true;
    }

    public void acceptEverything() {
        this.acceptAllEventTypes();
        this.setAndMask(0);
        this.setOrMask(63);
        this.setNotMask(0);
        this.acceptAllClickCounts();
    }

    public boolean getAcceptsKeyPressed() {
        return this.acceptsKeyPressed;
    }

    public boolean getAcceptsKeyReleased() {
        return this.acceptsKeyReleased;
    }

    public boolean getAcceptsKeyTyped() {
        return this.acceptsKeyTyped;
    }

    public boolean getAcceptsMouseClicked() {
        return this.acceptsMouseClicked;
    }

    public boolean getAcceptsMouseDragged() {
        return this.acceptsMouseDragged;
    }

    public boolean getAcceptsMouseEntered() {
        return this.acceptsMouseEntered;
    }

    public boolean getAcceptsMouseExited() {
        return this.acceptsMouseExited;
    }

    public boolean getAcceptsMouseMoved() {
        return this.acceptsMouseMoved;
    }

    public boolean getAcceptsMousePressed() {
        return this.acceptsMousePressed;
    }

    public boolean getAcceptsMouseReleased() {
        return this.acceptsMouseReleased;
    }

    public boolean getAcceptsMouseWheelRotated() {
        return this.acceptsMouseWheelRotated;
    }

    public boolean getAcceptsFocusEvents() {
        return this.acceptsFocusEvents;
    }

    public boolean getAcceptsAlreadyHandledEvents() {
        return this.acceptsAlreadyHandledEvents;
    }

    public boolean getMarksAcceptedEventsAsHandled() {
        return this.marksAcceptedEventsAsHandled;
    }

    public void rejectAllClickCounts() {
        this.clickCount = Short.MAX_VALUE;
    }

    public void rejectAllEventTypes() {
        this.acceptsKeyPressed = false;
        this.acceptsKeyReleased = false;
        this.acceptsKeyTyped = false;
        this.acceptsMouseClicked = false;
        this.acceptsMouseDragged = false;
        this.acceptsMouseEntered = false;
        this.acceptsMouseExited = false;
        this.acceptsMouseMoved = false;
        this.acceptsMousePressed = false;
        this.acceptsMouseReleased = false;
        this.acceptsMouseWheelRotated = false;
        this.acceptsFocusEvents = false;
    }

    public void setAcceptClickCount(short aClickCount) {
        this.clickCount = aClickCount;
    }

    public void setAcceptsKeyPressed(boolean aBoolean) {
        this.acceptsKeyPressed = aBoolean;
    }

    public void setAcceptsKeyReleased(boolean aBoolean) {
        this.acceptsKeyReleased = aBoolean;
    }

    public void setAcceptsKeyTyped(boolean aBoolean) {
        this.acceptsKeyTyped = aBoolean;
    }

    public void setAcceptsMouseClicked(boolean aBoolean) {
        this.acceptsMouseClicked = aBoolean;
    }

    public void setAcceptsMouseDragged(boolean aBoolean) {
        this.acceptsMouseDragged = aBoolean;
    }

    public void setAcceptsMouseEntered(boolean aBoolean) {
        this.acceptsMouseEntered = aBoolean;
    }

    public void setAcceptsMouseExited(boolean aBoolean) {
        this.acceptsMouseExited = aBoolean;
    }

    public void setAcceptsMouseMoved(boolean aBoolean) {
        this.acceptsMouseMoved = aBoolean;
    }

    public void setAcceptsMousePressed(boolean aBoolean) {
        this.acceptsMousePressed = aBoolean;
    }

    public void setAcceptsMouseReleased(boolean aBoolean) {
        this.acceptsMouseReleased = aBoolean;
    }

    public void setAcceptsMouseWheelRotated(boolean aBoolean) {
        this.acceptsMouseWheelRotated = aBoolean;
    }

    public void setAcceptsFocusEvents(boolean aBoolean) {
        this.acceptsFocusEvents = aBoolean;
    }

    public void setAndMask(int aAndMask) {
        this.andMask = aAndMask;
    }

    public void setAcceptsAlreadyHandledEvents(boolean aBoolean) {
        this.acceptsAlreadyHandledEvents = aBoolean;
    }

    public void setMarksAcceptedEventsAsHandled(boolean aBoolean) {
        this.marksAcceptedEventsAsHandled = aBoolean;
    }

    public void setNotMask(int aNotMask) {
        this.notMask = aNotMask;
    }

    public void setOrMask(int aOrMask) {
        this.orMask = aOrMask;
    }
}

